/*****************************************************************************
 * ugBASIC - an isomorphic BASIC language compiler for retrocomputers        *
 *****************************************************************************
 * Copyright 2021-2022 Marco Spedaletti (asimov@mclink.it)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *----------------------------------------------------------------------------
 * Concesso in licenza secondo i termini della Licenza Apache, versione 2.0
 * (la "Licenza"); è proibito usare questo file se non in conformità alla
 * Licenza. Una copia della Licenza è disponibile all'indirizzo:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Se non richiesto dalla legislazione vigente o concordato per iscritto,
 * il software distribuito nei termini della Licenza è distribuito
 * "COSÌ COM'È", SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO, esplicite o
 * implicite. Consultare la Licenza per il testo specifico che regola le
 * autorizzazioni e le limitazioni previste dalla medesima.
 ****************************************************************************/

/****************************************************************************
 * INCLUDE SECTION 
 ****************************************************************************/

#include "../../ugbc.h"

/****************************************************************************
 * CODE SECTION 
 ****************************************************************************/

/**
 * @brief Emit source and configuration lines for game loops
 * 
 * This function can be called to generate all the definitions (on the source
 * file, on the configuration file and on any support file) necessary to 
 * implement the memory banks.
 * 
 * @param _environment Current calling environment
 */
void gameloop_cleanup( Environment * _environment ) {

    if ( _environment->hasGameLoop ) {
        end_gameloop( _environment );
    }
    
}

void end_compilation( Environment * _environment ) {

    gameloop_cleanup( _environment );

    halt( _environment );
        
    bank_cleanup( _environment );
    every_cleanup( _environment );
    variable_cleanup( _environment );
    dstring_cleanup( _environment );
    
    target_finalization( _environment );

    if ( _environment->configurationFileName ) {
        linker_setup( _environment );
        linker_cleanup( _environment );
        fclose(_environment->configurationFile);
    }

    if ( _environment->debuggerLabelsFile ) {
        fclose(_environment->debuggerLabelsFile);
    }

    fclose(_environment->asmFile);

}

void end_build( Environment * _environment ) {

    target_finalize( _environment );

    target_cleanup( _environment );
    
}
